#include <iostream>
#include <string>
#include <vector>
#include "FileHandler.h"
#include "CoarseMol.h"



using namespace std;


int main(int argc, char* argv[])
{
  //if(argc < 2 || argc > 7)  usage();
  char *pdbInp = 0, *cidf = 0, *pqrmOut = 0;
  pdbInp = argv[1];
  cidf = "standard.cidf";
  pqrmOut = "output.pqrm"; 
  vector<Atom>::iterator p; // go along all residues in PDB
  FileHandler filehandler;
  bool haltOnErrors = false;

  if(argc < 2 || argc > 7)  filehandler.usage();

  if(argc == 2 && ( string(argv[1]).compare("/?") == 0 || string(argv[1]).compare("--help") == 0
                    || string(argv[1]).compare("-help") == 0 ) )  // show help
		    filehandler.usage();
  if(argc > 2)
  {
    int i;
    for(i = 2; i < argc; ++i)
    {
      if(string(argv[i]).find_first_of('-') == 0)  // arguments beginning with '-'
      {
        if(string(argv[i]).compare("-i") == 0 && i < argc - 1)  // option -i is set and has a following argument
        {
          cidf = argv[i + 1];
          continue;
        }
        if(string(argv[i]).compare("-o") == 0 && i < argc - 1)  // option -o is set and has a following argument
        {
          pqrmOut = argv[i + 1];
          continue;
        }
        if(string(argv[i]).compare("-h") == 0)                  // option -h is set
        {
          haltOnErrors = true;
          continue;
        }
        filehandler.usage();  // option not available
      }
    }
  }
  
  Protein prot;
  Map map;
 
  unsigned int atomNo=filehandler.readPDB(pdbInp, &prot); // no. of atoms of the pdb file
  unsigned int ICno = filehandler.readCidf(cidf, &map);
  cout << "atoms " << atomNo << " ICs in Cidf " << ICno << endl;

  CoarseMol coarsegrainedMol;

  coarsegrainedMol.transform(&prot, &map);
  coarsegrainedMol.conectIC(&map);

  filehandler.writePQRM(pqrmOut, &coarsegrainedMol);

  return 0;
}
