#ifndef FILEHANDLER_H
#define FILEHANDLER_H

#include "CoarseMol.h"
#include "Protein.h"
#include "Map.h"
#include <sstream>

class FileHandler
{
 public:
  FileHandler();
  ~FileHandler();

  int readPDB(const char *filename, Protein *prot);
 
  int readCidf(const char *filename, Map *map);
  int writePQRM(const char *filename, CoarseMol *coarse);
  double str2dou(const string& str);
  int str2int(const string& str);
  void usage();
  string removeWs(string withWhitespaces);  // removes any kind of whitespace before and after a word or phrase
  string fillUp(const int& val);
};

#endif
