#include <stdio.h>
#include <iostream>
#include <cstdlib>
#include "FileHandler.h"


//#include "InteractionCenter.h"

using namespace std;

FileHandler::FileHandler(){};
FileHandler::~FileHandler(){};

double FileHandler::str2dou(const string& str)
{
  double val = 0.0;
  stringstream buffer(str);
  buffer >> val;
  return val;
}

int FileHandler::str2int(const string& str)
{

  int val = 0;
  stringstream buffer(str);
  buffer >> val;
  return val;
}

void FileHandler::usage()
{
  cout << endl << "**************************************************************" << endl;
  cout << "Usage: 'coarsegrain input-pdb-filename [OPTIONS]'" << endl << endl;
  cout << "-i cidf-filename       : name and path of the mapping file" << endl;
  cout << "-o output-pqrm-filename: name and path of the outputfile" << endl;
  cout << "-h                     : halt on errors (if mapping rules don't match exactly)" << endl;
  cout << "/? OR -help OR --help  : this help" << endl << endl;
  cout << "If -i is not chosen cidf-filename is set to standard.cidf" << endl;
  cout << "If -o is not chosen output-pqrm-filename is set to output.pqrm" << endl << endl;
  cout << "Example: 'coarsegrain 1bpi.pdb -i standard2.cidf -h'" << endl << endl;
  exit(1);
}

string FileHandler::removeWs(string withWhitespaces)
{
  const char* const whitespace = " \t\r\n\v\f";
  withWhitespaces.erase(0, withWhitespaces.find_first_not_of(whitespace));
  withWhitespaces.erase(withWhitespaces.find_last_not_of(whitespace) + 1);
  return withWhitespaces;         // now without whitespaces ;-)
}

string FileHandler::fillUp(const int& val)
{
  string space = " ";
  string s = "";
  int i;
  for(i = 0; i < val; i++) s += space;
  return s;
}

int FileHandler::readPDB(const char *filename, Protein *prot) 
{
  /* Variables */
  string line;
  ifstream input(filename);
  
  if(!input)
    {cout << "cannot open file" << endl;
      exit(1);
    }
 
  Atom readatom;
  int atomResi=0, resi_old=-1;
  int nchains=1;

  vector<Atom>::iterator p;

  while(getline(input,line))
    {if(line.substr(0,3).compare("TER") == 0)
	nchains++;
      
      if(line.substr(0, 4).compare("ATOM") == 0 || line.substr(0,6).compare("HETATM") == 0)
	{
	  readatom.recName=removeWs(line.substr(0,6));
	  readatom.atomNumber=str2int(line.substr(6,5));
	  readatom.atomName=removeWs(line.substr(12,5));
	  readatom.resName=removeWs(line.substr(16, 4));
	  readatom.chainID=removeWs(line.substr(20, 2));
	  readatom.resNumber=str2int(line.substr(22, 4));
	  readatom.x=str2dou(line.substr(30,8));
	  readatom.y=str2dou(line.substr(38,8));
	  readatom.z=str2dou(line.substr(46,8));
	  readatom.Bfact=str2dou(line.substr(60,6));
	  readatom.chainNumber=nchains;
	  (*prot).molecule.push_back(readatom);
	  if(readatom.resNumber==resi_old)
	    atomResi++;
	  else if((*prot).molecule.size()==1) //first atom
	    {atomResi=1;
	      resi_old=readatom.resNumber;
	    }
	  else
	    {p=(*prot).molecule.end()-1;
	      for(int i=1; i<=atomResi; i++)
		{
		  p--;
		  (*p).atomsInResidue=atomResi;
		}
	      atomResi=1;
	      resi_old=readatom.resNumber;
	    }
	}
    }
  p=(*prot).molecule.end();
  for(int i=1; i<=atomResi; i++)
    {
      p--;
      (*p).atomsInResidue=atomResi;
    }

  

  input.close();
  (*prot).natoms=(*prot).molecule.size();
  return (*prot).natoms;
}

int FileHandler::readCidf(const char *filename, Map *map)
{
  string line, resname;
  ifstream input(filename);
  InteractionCenter readIC;
  int colon, enditem;
  string::iterator p;
  //vector<string>::iterator q;
  vector<InteractionCenter>::iterator m;
  int i, ICresi=0;
  bool ConectEntry=false;

  if(!input)
    {cout << "cannot open file" << endl;
      exit(1);
    }
   
  while(getline(input,line))
    {
      if(line.substr(0, 7).compare("RESIDUE") == 0)
	{
	  line.erase(0,8);
	  line.erase(0,line.find_first_not_of(" "));
	  resname=line.substr(0,3);
	  
	  getline(input,line);
	  colon=line.find(':');
	  while(colon<5&&colon>0) //find all Icenter of this residue
	    {ICresi++;
	      readIC.ICname=removeWs(line.substr(0,colon));
	      line.erase(0,colon+1);
	      line.erase(0,line.find_first_not_of(" "));
	      enditem=line.find_first_of(" ");
	      
	      readIC.ICmass=str2dou(line.substr(0,enditem));
	      line.erase(0,enditem);
	      line.erase(0,line.find_first_not_of(" "));
	      
	      readIC.method=line.substr(0,6);
	      line.erase(0,6);
	      line.erase(0,line.find_first_not_of(" "));
	 
	      p=line.begin(); // find all atoms belonging to the Icenter

	      while(p != line.end())
		{
		  line.erase(0,line.find_first_not_of(" "));
		  enditem=line.find_first_of(" ");
		 
		  readIC.atomRoleNames.push_back(line.substr(0,enditem));
		  line.erase(0,enditem);
		  p=line.begin();
		}
	      readIC.resName=resname;

	      getline(input,line); 
	      colon=line.find(':'); 

	      (*map).rules.push_back(readIC);
	      readIC.atomRoleNames.clear();
	    }	  
	  
	  while(line.substr(0,6).compare("CONECT")==0)
	    {
	      ConectEntry=true;
	      line.erase(0,6);
	      line.erase(0,line.find_first_not_of(" "));
	      enditem=line.find_first_of(" ");

	      for(m=(*map).rules.end()-1; m>(*map).rules.begin(); m--)		
		if(line.substr(0,enditem).compare((*m).ICname)==0)
		  break;
	      
	      line.erase(0,line.find_first_of(" "));
	      line.erase(0,line.find_first_not_of(" "));

	      while(p != line.end())
		{
		  enditem=line.find_first_of(" ");
		  (*m).conectedICs.push_back(line.substr(0,enditem));
		
		  line.erase(0,line.find_first_of(" "));
		  line.erase(0,line.find_first_not_of(" "));
		}

	      getline(input,line);
	    }
	  
	  m=(*map).rules.end(); // assign number of IC in current residue
	
	  for(i=1; i<ICresi; i++)
	    {
	      m--;
	      (*m).ICinResi=ICresi;
	   
	      if(!ConectEntry) // if no Conect entry in cidf file
		{
		  //(*m).conectedICs.push_back((*(m-1)).ICname);
		  (*(m-1)).conectedICs.push_back((*m).ICname);
		}
	    }

	   m--;
	   (*m).ICinResi=ICresi;
	  
	  ICresi=0;
	  ConectEntry=false;
	  
	}
    }

  input.close();
  (*map).ICnumber=(*map).rules.size();
  return (*map).ICnumber;
}

int FileHandler::writePQRM(const char *filename, CoarseMol *coarseMol)
{
  fstream outputFile;
  outputFile.open(filename, ios::out);
  if (!outputFile.is_open())  cout << "Outputfile couldn't be opened!" << endl;
  if(!outputFile.good()) cout << "File doesn't exist!" << endl;

  /** write out atoms  **/
  unsigned int i;
  int ICno;

  vector<Atom>::iterator a;
  vector<int>::iterator c;
  ICno=(*coarseMol).coarse.size();


  for(a=(*coarseMol).coarse.begin(); a<(*coarseMol).coarse.end(); a++)
  {
    outputFile << left << setfill(' ') << setw(6) << (*a).recName;
    outputFile << right << setfill(' ') << setw(5) << (*a).atomNumber;    // right-justified
    outputFile << fillUp(1);
    if((*a).atomName.length() == 4) 
      outputFile << (*a).atomName;
    else  
      outputFile << fillUp(1) << setw(3) << left << (*a).atomName;
      
    //outputFile << atoms_array[i].altLoc;
    outputFile << right << setw(4) << (*a).resName;
    outputFile << fillUp(2);
    //outputFile << (*a).chainID;
    outputFile << right << setw(4) << (*a).resNumber;
    //outputFile << atoms_array[i].insertionCode;
    outputFile << fillUp(4);
    outputFile << fixed << setw(8) << setprecision(3) << (*a).x;
    outputFile << fixed << setw(8) << setprecision(3) << (*a).y;
    outputFile << fixed << setw(8) << setprecision(3) << (*a).z;
    outputFile << right << setw(11) << setprecision(6) << (*a).charge;
    outputFile << right << setw(8) << setprecision(3) << (*a).radius;
    outputFile << right << setw(8) << setprecision(3) << (*a).mass;
    outputFile << endl;
  }
  outputFile << "TER" << endl;
  /** write out conects **/
  for(i=1; i<= ICno; i++)
    {outputFile << "CONECT" << setw(5) << right << i;
      for(c=(*coarseMol).conect[i].begin(); c<(*coarseMol).conect[i].end(); c++)
	outputFile << setw(5) << right << *c;
      outputFile << endl;
    }
  


  outputFile << "END" << endl;
  outputFile.close();


  return 0;
}
