#include "CoarseMol.h"
#include <iostream>
#include <cstdlib>

using namespace std;

CoarseMol::CoarseMol(){};

CoarseMol::~CoarseMol(){};

int CoarseMol::transform(Protein *prot, Map *map)
{
  int i=1, j, ICs;
 
  bool resNameFound = false;
  vector<Atom>::iterator p; // go along all residues in PDB
  vector<InteractionCenter>::iterator q; // go along all ICenters in map
  //vector<string>::iterator q1; // points to first atom of one ICenter
  Atom createCoarse;
  
  q=(*map).rules.begin();
  for(p=(*prot).molecule.begin(); p!=(*prot).molecule.end(); p++)  // for all atoms in PDB
    {
      //cout << (*p).resName << " " << (*p).resNumber << " " << (*p).atomsInResidue << " " << (*p).atomName << endl;
      resNameFound=false;
      for(q=(*map).rules.begin(); q<(*map).rules.end(); q++) // search correct rule
	if((*p).resName == (*q).resName) // correct rule found
	  {resNameFound=true;
	    ICs=(*q).ICinResi;
	    for(j=1; j<=ICs; j++)
	      {
		createCoarse.atomNumber=i;
		i++;
		if((*q).method=="BYATOM")
		  transformByAtom(&createCoarse, q, p);
		else if((*q).method=="BYGEOM")
		  transformByGeom(&createCoarse, q, p, map);
		else
		  {cerr << "transformation method unknown for IC " << (*q).resName << " " << (*q).ICname << endl;
		    exit(1);
		  }
		q++;
		coarse.push_back(createCoarse);
	      }
	  }
      if(!resNameFound)
	{cerr << "WARNING: Residue " << (*p).resName << " not found in cidf " << endl;
	  cerr << "Residue omitted in pqrm file" << endl;
	}
      
      for(j=1; j<(*p).atomsInResidue; j++)
	{
	  //cout << (*p).atomName << " " << (*p).resName << " " << (*p).resNumber << endl;
	  p++;
	  }
    }
      
  
  return 0;
}
 
int CoarseMol::transformByAtom(Atom *createCoarse, vector<InteractionCenter>::iterator q, 
			       vector<Atom>::iterator p)
{  

  int resi;
  vector<Atom>::iterator p1; // go along all atoms of one residue  
  vector<string>::iterator q1; // points to first atom of one ICenter
  bool ICnameFound = false;
  ICnameFound=false; 
  p1=p;
   
  (*createCoarse).atomName=(*q).ICname;
  (*createCoarse).resName=(*q).resName;
  (*createCoarse).mass=(*q).ICmass;
  
  resi=(*p).resNumber;
  q1=(*q).atomRoleNames.begin();
  while((*p1).resNumber==resi)
    {
      if((*p1).atomName==*q1)
	{
	  (*createCoarse).recName=(*p1).recName;
	  (*createCoarse).chainID=(*p1).chainID;
	  (*createCoarse).resNumber=(*p1).resNumber;
	  (*createCoarse).x=(*p1).x;
	  (*createCoarse).y=(*p1).y;
	  (*createCoarse).z=(*p1).z;
	  (*createCoarse).Bfact=(*p1).Bfact;
	  (*createCoarse).charge=(*p1).charge;
	  (*createCoarse).radius=(*p1).radius;
	  ICnameFound=true;
	  //cout << "Byatom " << (*createCoarse).atomNumber << " " << (*p1).atomName << " " << *q1 << endl;
	  break;
	}
      else 
	p1++;
    }
  
  if(!ICnameFound)
    {cerr << "Atom " << *q1 << " not found in residue " << resi << endl;
      exit(1);
    }
  

  
  return 0;
  
}

int CoarseMol::transformByGeom(Atom *createCoarse, vector<InteractionCenter>::iterator q, 
			       vector<Atom>::iterator p, Map *map)
{
  int resi, n;
  double coor[3], bfact;
  vector<Atom>::iterator p1; // go along all atoms of one residue  
  vector<string>::iterator q1; // points to first atom of one ICenter
  bool ICnameFound = false;
  ICnameFound=false; 
  p1=p;
   
  for(int i=0; i<=2; i++)
    coor[i]=0;
  bfact=0;

  (*createCoarse).atomName=(*q).ICname;
  (*createCoarse).resName=(*q).resName;
  (*createCoarse).mass=(*q).ICmass;
  
  resi=(*p).resNumber;
  q1=(*q).atomRoleNames.begin();
  n=(*q).atomRoleNames.size();
  //while((*p1).resNumber==resi)
  for(int i=1; i<=n; i++)
    {
      /*coor[0] += (*p1).x;
      coor[1] += (*p1).y;
      coor[2] += (*p1).z;
      bfact += (*p1).Bfact;
      cout << "coor x " << coor[0] << endl;*/

  
      while((*p1).atomName!=*q1)
	  p1++;
      
      coor[0] += (*p1).x;
      coor[1] += (*p1).y;
      coor[2] += (*p1).z;
      bfact += (*p1).Bfact;
     
      (*createCoarse).recName=(*p1).recName;
      (*createCoarse).chainID=(*p1).chainID;
      (*createCoarse).resNumber=(*p1).resNumber;
      (*createCoarse).charge=(*p1).charge;
      (*createCoarse).radius=(*p1).radius;
      ICnameFound=true;
      //cout << "Bygeom " << (*createCoarse).atomNumber << " " << (*p1).atomName << " " << *q1 << endl;
      //break;
      q1++;
      p1=p;
    }
 
  (*createCoarse).x=coor[0]/n;
  (*createCoarse).y=coor[1]/n;
  (*createCoarse).z=coor[2]/n;
  (*createCoarse).Bfact=bfact/n;
  
  if(!ICnameFound)
    {cerr << "Atom " << *q1 << " not found in residue " << resi << endl;
      exit(1);
    }
  
  
  
  return 0;
  

}

int CoarseMol::conectIC(Map *map)
{
  vector<Atom>::iterator p1;
  vector<Atom>::iterator p2;
  int ICno; 
  vector<InteractionCenter>::iterator q; // go along all ICenters in map
  vector<string>::iterator q1; // points to first conect of one ICenter

  ICno=coarse.size();
  cout << "ICno " << ICno << endl;

  conect=new vector<int>[ICno+1];

  // conect side chain atoms to backbone of the same residue
  for(p1=coarse.begin(); p1<coarse.end(); p1++)
    { 
      for(q=(*map).rules.begin(); q<(*map).rules.end(); q++) // all ICs
	{
	  if((*q).resName==(*p1).resName && (*q).ICname==(*p1).atomName)
	    {
	      for(q1=(*q).conectedICs.begin(); q1<(*q).conectedICs.end(); q1++) // all conect entries
		{
		  for(p2=p1+1; p2<coarse.end(); p2++)
		    if((*p2).atomName==*q1)
		      break;

		  conect[(*p1).atomNumber].push_back((*p2).atomNumber);
		  conect[(*p2).atomNumber].push_back((*p1).atomNumber);  
		}
	    }
	}
    }

  // conect backbone atoms
  for(p1=coarse.begin(); p1<coarse.end()-1; p1++)
    {p2=p1+1;
      if((*p1).atomName=="BB")   // backbone ICs must have identifier BB 
	{
	  while((*p2).atomName!="BB" && p2<coarse.end()-1) // search next backbone atom
	    p2++;
	    
	  if ((*p1).chainID==(*p2).chainID && (*p2).atomName=="BB") 
	    {
	      conect[(*p1).atomNumber].push_back((*p2).atomNumber);
	      conect[(*p2).atomNumber].push_back((*p1).atomNumber);
	      //cout << "BB " << (*p1).atomNumber << " " << (*p2).atomNumber << endl;
	    }
	}
    }
  return 0;
}
