#ifndef ATOM_H
#define ATOM_H

#include <iostream>
#include <string>
#include <vector>
#include <iomanip>
#include <fstream>

using namespace std;


class Atom
{
 public: 
  string recName;               // ATOM or HETATM
  int atomNumber;                 // atom serial number
  string atomName;                // atom role name, e.g. "CG1" or "HG21"
  string resName;                 // amino acid abbreviation, e.g. "ARG"
  string chainID;                 // two differ multichains, "A" or "B"
  int resNumber;                  // residue sequence number
  float x, y, z;                  // coordinates of the atom
  int chainNumber;                // increment after TER entry 
  double Bfact;                   // B-factor of the atom 
  int atomsInResidue;             // number of atoms of this residue

  //for pseudo atoms in pqrm
  double mass;
  double charge;
  double radius;
    
  // constructor & destructor
  Atom();
  ~Atom();

};


#endif
