/*---------------------------------------------------------
    This file is part of the program suite TEN
    (Tools for Elastic Networks)

    Copyright (C)

	Lars Ackermann
    G. Matthias Ullmann
    Bayreuth 2014

    www.bisb.uni-bayreuth.de

    This program is free software: you can redistribute
    it and/or modify it under the terms of the
    GNU Affero General Public License as published by the
    Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will
    be useful, but WITHOUT ANY WARRANTY; without even the
    implied warranty of MERCHANTABILITY or FITNESS FOR A
    PARTICULAR PURPOSE. See the GNU General Public License
    for more details.

    You should have received a copy of the
    GNU Affero General Public License along with this
    program.  If not, see <http://www.gnu.org/licenses/>.
-----------------------------------------------------------*/


#include "SetupConstants.h"
#include <string.h>
#include <iostream>

using namespace std;

SetupConstants::SetupConstants() {
	//if there is a new property in the prop file just add it to this list to make the system recognize the new value
	//then you can use it where ever you want
	settings.insert(std::make_pair("massWeightedHessian", 1));
	settings.insert(std::make_pair("temp", 298));
	settings.insert(std::make_pair("uniGasConst", 1.986e-3));
	settings.insert(std::make_pair("traj_tstep", (1.0/30.0)));
	settings.insert(std::make_pair("print_traj", 1));
	settings.insert(std::make_pair("print_super", 1));
	settings.insert(std::make_pair("supertraj_steps", 50.0));
	settings.insert(std::make_pair("supertraj_tstep", 0.0));
	settings.insert(std::make_pair("compareConfs", 0.0));
	settings.insert(std::make_pair("writeConfDistances", 10.0));
}

SetupConstants::~SetupConstants() {
}

SettingsMap SetupConstants::getSettings() {
	return settings;
}

vector<string> SetupConstants::getNames(){
	return protNames;
}

vector<string> SetupConstants::getPaths(){
	return pqrmPaths;
}

vector<string> SetupConstants::getRefNames(){
	return refNames;
}

vector<string> SetupConstants::getRefPaths(){
	return refPaths;
}

MassMap SetupConstants::getMasses(){
	return allMasses;
}

BBMap SetupConstants::getBBNumbers(){
	return allBBNumbers;
}

PhaseMap SetupConstants::getPhases(){
	return phases;
}

vector<int> SetupConstants::getTrajs(){
	return trajs;
}

vector<int> SetupConstants::getSuperTrajs(){
	return superTrajs;
}

void SetupConstants::setNames(vector<string> given){
	protNames = given;
}

void SetupConstants::setPaths(vector<string> given){
	pqrmPaths = given;
}

void SetupConstants::setRefNames(vector<string> given){
	refNames = given;
}

void SetupConstants::setRefPaths(vector<string> given){
	refPaths = given;
}

void SetupConstants::updateSettingsMap(SettingsMap upToDateMap) {
	settings = upToDateMap;
}

void SetupConstants::setAllMasses(MassMap allMassesFromFile){
	allMasses = allMassesFromFile;
}

void SetupConstants::setAllBBNumbers(BBMap allBBNumbersFromFile){
	allBBNumbers = allBBNumbersFromFile;
}

void SetupConstants::addToPhaseMap(int key, double value){
	phases[key] = value;
}

void SetupConstants::setTrajs(vector<int> allTrajs){
	trajs = allTrajs;
}

void SetupConstants::setSuperTrajs(vector<int> allSuperTrajs){
	superTrajs = allSuperTrajs;
}

bool SetupConstants::isKeyValid(string key) {

	boost::unordered_map<std::string, double>::iterator it;
	it = settings.find(key);
	if(it == settings.end()){
		return false;
	}else{
		return true;
	}
}
