/*---------------------------------------------------------
    This file is part of the program suite TEN
    (Tools for Elastic Networks)

    Copyright (C)

	Lars Ackermann
    G. Matthias Ullmann
    Bayreuth 2014

    www.bisb.uni-bayreuth.de

    This program is free software: you can redistribute
    it and/or modify it under the terms of the
    GNU Affero General Public License as published by the
    Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will
    be useful, but WITHOUT ANY WARRANTY; without even the
    implied warranty of MERCHANTABILITY or FITNESS FOR A
    PARTICULAR PURPOSE. See the GNU General Public License
    for more details.

    You should have received a copy of the
    GNU Affero General Public License along with this
    program.  If not, see <http://www.gnu.org/licenses/>.
-----------------------------------------------------------*/


#include "ConfComparator.h"

ConfComparator::ConfComparator(FileHandler* fileHandler, SetupConstants* settings) {
	this -> fileHandler = fileHandler;
	this -> settings = settings;
}

ConfComparator::~ConfComparator() {
	for (uint i = 0; i < coordinateColumnSize; i++) {
		delete[] refDiffMatrix[i];
	}
	delete[] refDiffMatrix;
}

vector<pair<double, float> > ConfComparator::getMinimalDiff() {
	return minimalDiff;
}

void ConfComparator::setRefCoords(vector<vector<double> > given, const char* refName) {
	vector<double> refCoordsX = given.at(0);
	vector<double> refCoordsY = given.at(1);
	vector<double> refCoordsZ = given.at(2);
	refDiffMatrix = new float*[refCoordsX.size()];
	for (uint i = 0; i < refCoordsX.size(); i++) {
		*(refDiffMatrix + i) = new float[refCoordsX.size()];
	}

	BBMap bbMap = settings -> getBBNumbers();
	vector<int> refBBNumbers = bbMap[refName];

	for (uint i = 0; i < refBBNumbers.size(); i++) {
		for (uint j = i + 1; j < refBBNumbers.size(); j++) {
			int first = refBBNumbers.at(i);
			int second = refBBNumbers.at(j);

			double dxRef = refCoordsX[first] - refCoordsX[second];
			double dyRef = refCoordsY[first] - refCoordsY[second];
			double dzRef = refCoordsZ[first] - refCoordsZ[second];

			refDiffMatrix[first][second] = sqrt(pow(dxRef, 2) + pow(dyRef, 2) + pow(dzRef, 2));
		}
	}
	coordinateColumnSize = refCoordsX.size();
}

void ConfComparator::setTimeStepCoords(float** given) {
	timeStepCoords = given;
}

float ConfComparator::calculateDiff(double time, const char* protName, const char* refName) {

	SettingsMap setMap = settings -> getSettings();
	BBMap bbMap = settings -> getBBNumbers();
	vector<int> protBBNumbers = bbMap[protName];
	vector<int> refBBNumbers = bbMap[refName];

	float diff = 0.0;

	for (uint i = 0; i < protBBNumbers.size(); i++) {
		for (uint j = i + 1; j < protBBNumbers.size(); j++) {
			int first = protBBNumbers.at(i);
			int second = protBBNumbers.at(j);
			double dx = timeStepCoords[0][first] - timeStepCoords[0][second];
			double dy = timeStepCoords[1][first] - timeStepCoords[1][second];
			double dz = timeStepCoords[2][first] - timeStepCoords[2][second];

			first = refBBNumbers.at(i);
			second = refBBNumbers.at(j);

			diff += abs(sqrt(pow(dx, 2) + pow(dy, 2) + pow(dz, 2)) - refDiffMatrix[first][second]);
		}
	}

	//add new (small) value to minimal differences or replace a bigger one inside the vector
	double diffCopy = diff;
	double timeCopy = time;
	if (minimalDiff.size() == 0) {
		minimalDiff.push_back(make_pair(timeCopy, diffCopy));
	} else {
		for (uint p = 0; p < minimalDiff.size(); p++) {
			pair<double, float> currentPair = minimalDiff.at(p);
			if (diffCopy < currentPair.second) {
				double oldDiff = minimalDiff.at(p).second;
				double oldTime = minimalDiff.at(p).first;
				minimalDiff.at(p) = make_pair(timeCopy, diffCopy);
				diffCopy = oldDiff;
				timeCopy = oldTime;
				if (p == (minimalDiff.size() - 1) and minimalDiff.size() < setMap["writeConfDistances"]) {
					minimalDiff.push_back(make_pair(timeCopy, diffCopy));
					break;
				}
			}
		}
	}

	return diff;
}
