/* einige Hilfsfunktionen.						*/
/*......................................................................*/
#ifndef __util__
#define __util__
/*----------------------------------------------------------------------*/
#include <stdio.h>
#include <limits.h>
#include <float.h>
#include "constants.h"

/*----------------------------------------------------------------------*/
/* Debug stuff								*/
#ifdef DEBUG
#define DEBUGGING(something)  something;
#else
#define DEBUGGING(something)  /*something;*/
#endif


#define TEST {fprintf(stderr,"HIER\n"); getchar();}
#define TEST2(a) {fprintf(stderr,"HIER:  %d\n",a); getchar();}
#define TEST3(a) {fprintf(stderr,"HIER:  %d\n",a);}
#define TEST_D(a) {fprintf(stderr,"HIER:  %e\n",a);}
#define STEST(a) {fprintf(stderr,"HIER:  %s\n",a);}
/*----------------------------------------------------------------------*/

#define NR_END 1
#define FREE_ARG void*
/*----------------------------------------------------------------------*/
#define STDERR stderr

/* READ_LINE should not be used in while loops!!!!	*/
/* Rather use while(fgets()!=NULL			*/
#ifndef READ_LINE
#define READ_LINE(line, fpin) {if (fgets(line,LINELENGTH,fpin)==NULL)\
			          muerror("File too short.");}

#endif

#define SAVE_fread(ptr, size, nobj, fp) \
	{if (nobj!=fread(ptr, size, nobj, fp)) muerror("Can not read a binary file");}

#define SAVE_fwrite(ptr, size, nobj, fp) \
	{if (nobj!=fwrite(ptr, size, nobj, fp)) muerror("Can not write a binary file");}

#ifndef PRINT_dVEC
#define PRINT_dVEC(fpout,a)  (fprintf(fpout,"%8.3lf  %8.3lf  %8.3lf\n",a[1],a[2],a[3]))
#endif

#ifndef PRINT_iVEC
#define PRINT_iVEC(fpout,a)  (fprintf(fpout,"%8.3d  %8.3d  %8.3d\n",a[1],a[2],a[3]))
#endif

/* IO Stuff */								
void version(FILE *fp, char *name, char *ver);
void init_charvector(char *vec, int len, char val);
void replace_char(char *string, char newc, char old);
char *read_word(char *result, char *input);
FILE *file_open(char *filename, char *option);
void muerror(char error_text[]);
void muwarn(char error_text[]);
void usage(char *usagestring, int real_argument_number, int wished_argument_number);
int my_strcmp(char *string1, char *string2, char dummy);
int StringPerLine(char *line);
int number_of_lines(FILE *file);

/* CPU time */
void TimeAndDate(FILE *fp);
void CpuTime(FILE *fp);
void Prologue(char *programName);
void Epilogue(char *programName);

/* Memory Mangement functions */
long *long_vector(long nl, long nh);


short **short_matrix(long nrl, long nrh, long ncl, long nch);
void free_shortmatrix(short **m, long nrl, long nrh, long ncl, long nch);

char ***char_3tensor(long nrl, long nrh, long ncl, long nch, long ndl, long ndh);
void free_char3tensor(char ***t, long nrl, long nrh, long ncl, long nch,
	long ndl, long ndh);

char **charmatrix(long nrl, long nrh, long ncl, long nch);
void free_charmatrix(char **m, long nrl, long nrh, long ncl, long nch);

unsigned char **unsignedcharmatrix(long nrl, long nrh, long ncl, long nch);
void free_unsignedcharmatrix(unsigned char **m, long nrl, long nrh, long ncl, long nch);

char *charvector(long nl, long nh);
void free_charvector(char *v, long nl, long nh);

unsigned char *unsignedcharvector(long nl, long nh);
void free_unsignedcharvector(unsigned char *v, long nl, long nh);

double ***dpointer_vector(long nrl, long nrh);


double ***d3tensor(long nrl, long nrh, long ncl, long nch, long ndl, long ndh);
void free_d3tensor(double ***t, long nrl, long nrh, long ncl, long nch,
	long ndl, long ndh);

int ***i3tensor(long nrl, long nrh, long ncl, long nch, long ndl, long ndh);
void free_i3tensor(int ***t, long nrl, long nrh, long ncl, long nch,
	long ndl, long ndh);

int ****i4tensor(long nrl, long nrh, long ncl, long nch, 
		 long ndl, long ndh, long nwl, long nwh);
void free_i4tensor(int ****t, long nrl, long nrh, long ncl, long nch, 
		              long ndl, long ndh, long nwl, long nwh);

float ****f4tensor(long nrl, long nrh, long ncl, long nch, 
		   long ndl, long ndh, long nwl, long nwh);
void free_d4tensor(double ****t, long nrl, long nrh, long ncl, long nch, 
		                 long ndl, long ndh, long nwl, long nwh);

double ****d4tensor(long nrl, long nrh, long ncl, long nch, 
		    long ndl, long ndh, long nwl, long nwh);
void free_f4tensor(float ****t, long nrl, long nrh, long ncl, long nch, 
		              long ndl, long ndh, long nwl, long nwh);

int ******i6tensor(long nrl, long nrh, long ncl, long nch, 
		 long ndl, long ndh, long nwl, long nwh,
		 long nul, long nuh, long nvl, long nvh);
void free_i6tensor(int ******t, long nrl, long nrh, long ncl, long nch, 
		                long ndl, long ndh, long nwl, long nwh,
		                long nul, long nuh, long nvl, long nvh);



/* Other stuff */
char trans_3to1(char *residue);


#endif /* __util__ */
