/* einige Hilfsfunktionen.						*/
/* 4tensor und hoeher funktioniert nicht richtig			*/
/* free rountinen von NR funktionieren nicht!				*/
/*......................................................................*/

/* include-statements */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
/* #include <sys/types.h>
#include <sys/times.h>
#include <sys/param.h>*/
#include "util.h"

#define NR_END 1
#define FREE_ARG void*

/* .....................................................*/
/* Print program information and version number         */
void version(FILE *fp, char *name, char *ver)
{

    fprintf(fp,"%s Version %s\n",name, ver); 
}
/*..............................................................*/
/* assigns a given value to each membor of a char vector	*/
/*								*/
int number_of_lines(FILE *file)
{
int no;
char line[LINELENGTH];

no=0;
while (fgets(line,LINELENGTH,file)!=NULL)  
      {no++;
      }

rewind(file);

return no;
}

/*..............................................................*/
/* assigns a given value to each membor of a char vector	*/
/*								*/
void init_charvector(char *vec, int len, char val)
{
int i;

for (i=1; i<=len; i++)
    {vec[i]=val;
    }
}

/*..............................................................*/
/* replaces all chars old by the char new in the string 'string'*/
void replace_char(char *string, char newc, char old)
{
unsigned long i,len;

len=strlen(string);
for (i=0; i<len; i++)
    {if (old==string[i]) {string[i]=newc;}
    }
}
/*..............................................................*/
/* reads a word from string					*/
/* The word is started with the first non-' ' or non-'\t' and	*/
/* ended before the next ' ', '\n','\t' or '\0'			*/
/* The function returns a pointer place in the string, where	*/
/* the reading has stopped.					*/
/* If the string has ended, at in the function, NULL is returned*/
/* It no word is in the string, result is set to NULL		*/
/*								*/
char *read_word(char *result, char *input)
{
/* skip leading blacks */
while ((input[0]==' ')||(input[0]=='\t')||(input[0]=='\n')) input++;

/* Test if the string has alread ended */
if (input[0]=='\0')
   {result=NULL;
    return NULL;
   }
/* Now copy the word */
while (0==0)
      {result[0]=input[0];
       result++; 
       input++;
       if ( (input[0]==' ')||(input[0]=='\t')
	  ||(input[0]=='\n')||(input[0]=='\0'))
	  {break;
	  }
      }

result[0]='\0';
return input;
}
/*..............................................................*/
/* Function counts the words in a line. A word is defined to 	*/
/* start with a non-' ' and to end  with before the next ' ' 	*/
/* or NULL							*/
/*								*/
int StringPerLine(char *line)
{
int i=0, words=0;

/* To stop the line at '\n'*/
if (line[strlen(line)-1]=='\n')
   line[strlen(line)-1]='\0';

/* skip leading blacks */
while ((line[i]==' ')||(line[i]=='\t')||(line[i]=='\n')) i++;

/* line[i]==word begins */
while (line[i]!='\0')
   {words++;
    /* search for the word end */
    while ((line[i]!=' ') && (line[i]!='\t') && (line[i]!='\0')) 
	{i++;
	} 
    /* search for the next word start */
    while (((line[i]==' ') || (line[i]=='\t')) && (line[i]!='\0')) 
	{i++; 
	}
   }
return words;
}

/*..............................................................*/
/* Funktion compares two strings. Two strings are equal, if all */
/* characters are equal or if all characters are equal util the */
/* dummy comes. For instance, if a "NCT" and "N*" are equal and */
/* a NULL is returned;						*/
/* It returns 0 when both strings are equal, it returns 1, if 	*/
/* they are equal though the use of the dummy and it returns 2  */
/* id they are not equal.					*/

int my_strcmp(char *string1, char *string2, char dummy)
{
int back=0;
int i=0;

while ((string1[i]!='\0')&&(string2[i]!='\0'))
   {if (string1[i]!=string2[i])
       {if ((string1[i]==dummy)||(string2[i]==dummy)) 
	   {back=1;
	    break;
	   }
	else {back=2; 
	      break;
	     }
       }
    i++;
   }

if ((strlen(string1)!=strlen(string2))&& (back==0)) back=2;
return back;
}


/*..............................................................*/
/* standard error handler */
void muwarn(char error_text[])
{
	fprintf(STDERR,"\nWARNING: %s\n",error_text);
}

/*..............................................................*/
/* standard error handler */
void muerror(char error_text[])
{
	fprintf(STDERR,"Run-time error...\n");
	fprintf(STDERR,"ERROR: %s\n",error_text);
	fprintf(STDERR,"...now exiting to system...\n");
	exit(EXIT_FAILURE); 
}

/*..............................................................*/
/* function assigns a file to a file-pointer			*/
/* If the opening of the file fails, a error message appears and*/
/* the program terminates.					*/
/*								*/
/*	fpin=file_open(argv[1],"r");				*/
/*								*/

FILE *file_open(char *filename, char *option)
{

FILE *fpin;

if (strcmp(filename,"stdout") == 0) {fpin=stdout; goto end;}
if (strcmp(filename,"stderr") == 0) {fpin=stderr; goto end;}
if (strcmp(filename,"stdin")  == 0) {fpin=stdin;  goto end;}


if ((fpin = fopen(filename,option)) == NULL)
        {fprintf(stderr,"Could not open %s. Abort.\n", filename);
         exit(EXIT_FAILURE);
        }

/* fprintf(stderr,"I have opened %s.\n", filename);*/

end: /* label */
return fpin;
}

/*..............................................................*/
/* The correct usage is proved.					*/
/* If it is incorrect, a error message appears and		*/
/* the program terminates.					*/
/*								*/
/* 	usage("bgf2pdb <bgf>", argc, 2);			*/

void usage(char *usagestring, int real_argument_number, int wished_argument_number)
{

if (wished_argument_number!=real_argument_number)
   {fprintf(stderr,"%s\n",usagestring);
    exit(EXIT_FAILURE);
   }
}


/****************************************************************/
/*   		Memory Allocation 				*/
/*..............................................................*/
long *long_vector(long nl, long nh)
/* allocate an unsigned long vector with subscript range v[nl..nh] */
{
	long *v;

	v=(long *)malloc((size_t) ((nh-nl+1+NR_END)*sizeof(long)));
	if (!v) muerror("allocation failure in long_vector()");
	return v-nl+NR_END;
}

/*..............................................................*/
/* allocate a short matrix with subscript range m[nrl..nrh][ncl..nch] */
short **short_matrix(long nrl, long nrh, long ncl, long nch)
{
        long i, nrow=nrh-nrl+1,ncol=nch-ncl+1;
        short **m;

        /* allocate pointers to rows */
        m=(short **) malloc((size_t)((nrow+NR_END)*sizeof(short*)));
        if (!m) muerror("allocation failure 1 in short_matrix()");
        m += NR_END;
        m -= nrl;

        /* allocate rows and set pointers to them */
        m[nrl]=(short *) malloc((size_t)((nrow*ncol+NR_END)*sizeof(short)));
        if (!m[nrl]) muerror("allocation failure 2 in short_matrix()");
        m[nrl] += NR_END;
        m[nrl] -= ncl;

        for(i=nrl+1;i<=nrh;i++) m[i]=m[i-1]+ncol;

        /* return pointer to array of pointers to rows */
        return m;
}

/*...............................................................*/
/* free a short matrix with subscript range m[nrl..nrh][ncl..nch] */
void free_shortmatrix(short **m, long nrl, long nrh, long ncl, long nch)
{
if (m!=NULL)
	{free((FREE_ARG) (m[nrl]+ncl-NR_END));
	 free((FREE_ARG) (m+nrl-NR_END));
	}
}


/*..............................................................*/
/* allocate a char matrix with subscript range m[nrl..nrh][ncl..nch] */
char **charmatrix(long nrl, long nrh, long ncl, long nch)
{
        long i, nrow=nrh-nrl+1,ncol=nch-ncl+1;
        char **m;

        /* allocate pointers to rows */
        m=(char **) malloc((size_t)((nrow+NR_END)*sizeof(char*)));
        if (!m) 
	   {fprintf(stderr,"Rows: %d  Columns: %d \n",nrh,ncol);
	    muerror("allocation failure 1 in charmatrix()");
	   }
        m += NR_END;
        m -= nrl;

        /* allocate rows and set pointers to them */
        m[nrl]=(char *) malloc((size_t)((nrow*ncol+NR_END)*sizeof(char)));
        if (!m[nrl]) muerror("allocation failure 2 in charmatrix()");
        m[nrl] += NR_END;
        m[nrl] -= ncl;

        for(i=nrl+1;i<=nrh;i++) m[i]=m[i-1]+ncol;

        /* return pointer to array of pointers to rows */
        return m;
}

/*...............................................................*/
/* free a char matrix with subscript range m[nrl..nrh][ncl..nch] */
void free_charmatrix(char **m, long nrl, long nrh, long ncl, long nch)
{
if (m!=NULL)
	{free((FREE_ARG) (m[nrl]+ncl-NR_END));
	 free((FREE_ARG) (m+nrl-NR_END));
	}
}
/*..............................................................*/
/* allocate a char matrix with subscript range m[nrl..nrh][ncl..nch] */
unsigned char **unsignedcharmatrix(long nrl, long nrh, long ncl, long nch)
{
        long i, nrow=nrh-nrl+1,ncol=nch-ncl+1;
        unsigned char **m;

        /* allocate pointers to rows */
        m=(unsigned char **) malloc((size_t)((nrow+NR_END)*sizeof(unsigned char*)));
        if (!m) 
	   {fprintf(stderr,"Rows: %d  Columns: %d \n",nrh,ncol);
	    muerror("allocation failure 1 in charmatrix()");
	   }
        m += NR_END;
        m -= nrl;

        /* allocate rows and set pointers to them */
        m[nrl]=(unsigned char *) malloc((size_t)((nrow*ncol+NR_END)*sizeof(unsigned char)));
        if (!m[nrl]) muerror("allocation failure 2 in charmatrix()");
        m[nrl] += NR_END;
        m[nrl] -= ncl;

        for(i=nrl+1;i<=nrh;i++) m[i]=m[i-1]+ncol;

        /* return pointer to array of pointers to rows */
        return m;
}

/*...............................................................*/
/* free a char matrix with subscript range m[nrl..nrh][ncl..nch] */
void free_unsignedcharmatrix(unsigned char **m, long nrl, long nrh, long ncl, long nch)
{
if (m!=NULL)
	{free((FREE_ARG) (m[nrl]+ncl-NR_END));
	 free((FREE_ARG) (m+nrl-NR_END));
	}
}


/*......................................................*/
/* allocate a char vector with subscript range v[nl..nh] */
char *charvector(long nl, long nh)
{
        char *v;

	v=(char *)malloc((size_t) ((nh-nl+1+NR_END)*sizeof(char)));
	if (!v) muerror("allocation failure in charvector()");
	return v-nl+NR_END;
}

/*......................................................*/
/* free a char vector with subscript range v[nl..nh]    */
void free_charvector(char *v, long nl, long nh)
{
if (v!=NULL)	free((FREE_ARG) (v+nl-NR_END));
}

/*......................................................*/
/* allocate a char vector with subscript range v[nl..nh] */
unsigned char *unsignedcharvector(long nl, long nh)
{
        char *v;

	v=(char *)malloc((size_t) ((nh-nl+1+NR_END)*sizeof(unsigned char)));
	if (!v) muerror("allocation failure in unsignedcharvector()");
	return v-nl+NR_END;
}

/*......................................................*/
/* free a char vector with subscript range v[nl..nh]    */
void free_unsignedcharvector(unsigned char *v, long nl, long nh)
{
if (v!=NULL)	free((FREE_ARG) (v+nl-NR_END));
}



/*..............................................................................*/
/* allocate a double 3tensor with range t[nrl..nrh][ncl..nch][ndl..ndh] 	*/
double ***d3tensor(long nrl, long nrh, long ncl, long nch, long ndl, long ndh)
{
	long i,j,nrow=nrh-nrl+1,ncol=nch-ncl+1,ndep=ndh-ndl+1;
	double ***t;

	/* allocate pointers to pointers to rows */
	t=(double ***) malloc((size_t)((nrow+NR_END)*sizeof(double**)));
	if (!t) muerror("allocation failure 1 in d3tensor()");
	t += NR_END;
	t -= nrl;

	/* allocate pointers to rows and set pointers to them */
	t[nrl]=(double **) malloc((size_t)((nrow*ncol+NR_END)*sizeof(double*)));
	if (!t[nrl]) muerror("allocation failure 2 in d3tensor()");
	t[nrl] += NR_END;
	t[nrl] -= ncl;

	/* allocate rows and set pointers to them */
	t[nrl][ncl]=(double *) malloc((size_t)((nrow*ncol*ndep+NR_END)*sizeof(double)));
	if (!t[nrl][ncl]) muerror("allocation failure 3 in d3tensor()");
	t[nrl][ncl] += NR_END;
	t[nrl][ncl] -= ndl;

	for(j=ncl+1;j<=nch;j++) t[nrl][j]=t[nrl][j-1]+ndep;
	for(i=nrl+1;i<=nrh;i++) {
		t[i]=t[i-1]+ncol;
		t[i][ncl]=t[i-1][ncl]+ncol*ndep;
		for(j=ncl+1;j<=nch;j++) t[i][j]=t[i][j-1]+ndep;
	}

	/* return pointer to array of pointers to rows */
	return t;
}
/*..............................................................................*/
/* free a double d3tensor allocated by d3tensor() 				*/
void free_d3tensor(double ***t, long nrl, long nrh, long ncl, long nch,
	long ndl, long ndh)
{
if (t!=NULL)	{free((FREE_ARG) (t[nrl][ncl]+ndl-NR_END));
	 free((FREE_ARG) (t[nrl]+ncl-NR_END));
	 free((FREE_ARG) (t+nrl-NR_END));
	}
}

/*..............................................................................*/
/* allocate a char 3tensor with range t[nrl..nrh][ncl..nch][ndl..ndh] 	*/
char ***char_3tensor(long nrl, long nrh, long ncl, long nch, long ndl, long ndh)
{
	long i,j,nrow=nrh-nrl+1,ncol=nch-ncl+1,ndep=ndh-ndl+1;
	char ***t;

	/* allocate pointers to pointers to rows */
	t=(char ***) malloc((size_t)((nrow+NR_END)*sizeof(char**)));
	if (!t) muerror("allocation failure 1 in char_3tensor()");
	t += NR_END;
	t -= nrl;

	/* allocate pointers to rows and set pointers to them */
	t[nrl]=(char **) malloc((size_t)((nrow*ncol+NR_END)*sizeof(char*)));
	if (!t[nrl]) muerror("allocation failure 2 in char_3tensor()");
	t[nrl] += NR_END;
	t[nrl] -= ncl;

	/* allocate rows and set pointers to them */
	t[nrl][ncl]=(char *) malloc((size_t)((nrow*ncol*ndep+NR_END)*sizeof(char)));
	if (!t[nrl][ncl]) muerror("allocation failure 3 in char_3tensor()");
	t[nrl][ncl] += NR_END;
	t[nrl][ncl] -= ndl;

	for(j=ncl+1;j<=nch;j++) t[nrl][j]=t[nrl][j-1]+ndep;
	for(i=nrl+1;i<=nrh;i++) {
		t[i]=t[i-1]+ncol;
		t[i][ncl]=t[i-1][ncl]+ncol*ndep;
		for(j=ncl+1;j<=nch;j++) t[i][j]=t[i][j-1]+ndep;
	}

	/* return pointer to array of pointers to rows */
	return t;
}

/*..............................................................................*/
/* free a char d3tensor allocated by d3tensor() 				*/
void free_char3tensor(char ***t, long nrl, long nrh, long ncl, long nch,
	long ndl, long ndh)
{
if (t!=NULL)	{free((FREE_ARG) (t[nrl][ncl]+ndl-NR_END));
	 free((FREE_ARG) (t[nrl]+ncl-NR_END));
	 free((FREE_ARG) (t+nrl-NR_END));
	}
}

/*..............................................................................*/
/* allocate a integer 3tensor with range t[nrl..nrh][ncl..nch][ndl..ndh] 	*/
int ***i3tensor(long nrl, long nrh, long ncl, long nch, long ndl, long ndh)
{
	long i,j,nrow=nrh-nrl+1,ncol=nch-ncl+1,ndep=ndh-ndl+1;
	int ***t;

	/* allocate pointers to pointers to rows */
	t=(int ***) malloc((size_t)((nrow+NR_END)*sizeof(int**)));
	if (!t) muerror("allocation failure 1 in i3tensor()");
	t += NR_END;
	t -= nrl;

	/* allocate pointers to rows and set pointers to them */
	t[nrl]=(int **) malloc((size_t)((nrow*ncol+NR_END)*sizeof(int*)));
	if (!t[nrl]) muerror("allocation failure 2 in i3tensor()");
	t[nrl] += NR_END;
	t[nrl] -= ncl;

	/* allocate rows and set pointers to them */
	t[nrl][ncl]=(int *) malloc((size_t)((nrow*ncol*ndep+NR_END)*sizeof(int)));
	if (!t[nrl][ncl]) muerror("allocation failure 3 in i3tensor()");
	t[nrl][ncl] += NR_END;
	t[nrl][ncl] -= ndl;

	for(j=ncl+1;j<=nch;j++) t[nrl][j]=t[nrl][j-1]+ndep;
	for(i=nrl+1;i<=nrh;i++) {
		t[i]=t[i-1]+ncol;
		t[i][ncl]=t[i-1][ncl]+ncol*ndep;
		for(j=ncl+1;j<=nch;j++) t[i][j]=t[i][j-1]+ndep;
	}

	/* return pointer to array of pointers to rows */
	return t;
}
/*..............................................................................*/
/* free a integer i3tensor allocated by i3tensor() 				*/
void free_i3tensor(int ***t, long nrl, long nrh, long ncl, long nch,
	long ndl, long ndh)
{
if (t!=NULL)
	{free((FREE_ARG) (t[nrl][ncl]+ndl-NR_END));
	 free((FREE_ARG) (t[nrl]+ncl-NR_END));
	 free((FREE_ARG) (t+nrl-NR_END));
	}
}

/*..............................................................................*/
/* allocates the memory for a int 4d-tensor					*/
/* range: t[nrl..nrh][ncl..nch][ndl..ndh][nwl..nwh]				*/
/* Form Daniel Hoffmann (in NR Convention)					*/

int ****i4tensor(long nrl, long nrh, long ncl, long nch, 
		 long ndl, long ndh, long nwl, long nwh)
{
  long i,j,k,nrow=nrh-nrl+1,ncol=nch-ncl+1,ndep=ndh-ndl+1,nwid=nwh-nwl+1;
  int ****t4, ***t3, **t2, *t1;

  k=nrow*ncol*ndep*nwid;

  t1=(int *)malloc((size_t)(k*sizeof(int)));
  if (!t1)
    muerror("allocation failure 1 in i4tensor");
  t1-=nwl;

  k/=nwid;
  t2=(int **)malloc((size_t)(k*sizeof(int*)));
  if (!t2)
    muerror("allocation failure 2 in i4tensor");
  t2-=ndl;
  for (i=0, j=0; i<k; i++, j+=nwid)
    t2[ndl+i]=&(t1[j]);
    
  k/=ndep;
  t3=(int ***)malloc((size_t)(k*sizeof(int**)));
  if (!t3)
    muerror("allocation failure 3 in i4tensor");
  t3-=ncl;
  for (i=0, j=0; i<k; i++, j+=ndep)
    t3[ncl+i]=&(t2[j]);
    
  k/=ncol;
  t4=(int ****)malloc((size_t)(k*sizeof(int***)));
  if (!t4)
    muerror("allocation failure 4 in i4tensor");
  t4-=nrl;
  for (i=0, j=0; i<k; i++, j+=ncol)
    t4[nrl+i]=&(t3[j]);
    
  return t4;
}
/*..............................................................................*/
/* free a integer i4tensor allocated by i4tensor() 				*/
void free_i4tensor(int ****t, long nrl, long nrh, long ncl, long nch, 
		              long ndl, long ndh, long nwl, long nwh)
{
if (t!=NULL)
	{free((FREE_ARG) (&t[nrl][ncl][ndl][nwl]));
	 free((FREE_ARG) (&t[nrl][ncl][ndl]));
	 free((FREE_ARG) (&t[nrl][ncl]));
	 free((FREE_ARG) (&t[nrl]));
	}
}
/*..............................................................................*/
/* allocates the memory for a int 4d-tensor					*/
/* range: t[nrl..nrh][ncl..nch][ndl..ndh][nwl..nwh][nul..nuh][nvl..nvh]		*/
/* Form Daniel Hoffmann (in NR Convention), modified				*/

int ******i6tensor(long nrl, long nrh, long ncl, long nch, 
		 long ndl, long ndh, long nwl, long nwh,
		 long nul, long nuh, long nvl, long nvh)
{
  long i,j,k;
  long nrow=nrh-nrl+1,ncol=nch-ncl+1,ndep=ndh-ndl+1,nwid=nwh-nwl+1,
        nu =nuh-nul+1, nv =nvh-nvl+1;
  int ******t6, *****t5, ****t4, ***t3, **t2, *t1;

  k=nrow*ncol*ndep*nwid*nu*nv;

  t1=(int *)malloc((size_t)(k*sizeof(int)));
  if (!t1)
    muerror("allocation failure 1 in i6tensor");
  t1-=nvl;

  k/=nv;
  t2=(int **)malloc((size_t)(k*sizeof(int*)));
  if (!t2)
    muerror("allocation failure 2 in i6tensor");
  t2-=nul;
  for (i=0, j=0; i<k; i++, j+=nv)
    t2[nul+i]=&(t1[j]);

  k/=nu;
  t3=(int ***)malloc((size_t)(k*sizeof(int**)));
  if (!t3)
    muerror("allocation failure 3 in i6tensor");
  t3-=nwl;
  for (i=0, j=0; i<k; i++, j+=nu)
    t3[nwl+i]=&(t2[j]);

  k/=nwid;
  t4=(int ****)malloc((size_t)(k*sizeof(int***)));
  if (!t4)
    muerror("allocation failure 4 in i6tensor");
  t4-=ndl;
  for (i=0, j=0; i<k; i++, j+=nwid)
    t4[ndl+i]=&(t3[j]);
    
  k/=ndep;
  t5=(int *****)malloc((size_t)(k*sizeof(int****)));
  if (!t5)
    muerror("allocation failure 5 in i6tensor");
  t5-=ncl;
  for (i=0, j=0; i<k; i++, j+=ndep)
    t5[ncl+i]=&(t4[j]);
    
  k/=ncol;
  t6=(int ******)malloc((size_t)(k*sizeof(int*****)));
  if (!t6)
    muerror("allocation failure 6 in i6tensor");
  t6-=nrl;
  for (i=0, j=0; i<k; i++, j+=ncol)
    t6[nrl+i]=&(t5[j]);
    
  return t6;
}
/*..............................................................................*/
/* free a integer i6tensor allocated by i6tensor() 				*/
void free_i6tensor(int ******t, long nrl, long nrh, long ncl, long nch, 
		                long ndl, long ndh, long nwl, long nwh,
		                long nul, long nuh, long nvl, long nvh)
{
if (t!=NULL)
       {free((FREE_ARG) (&t[nrl][ncl][ndl][nwl][nul][nvl]));
	free((FREE_ARG) (&t[nrl][ncl][ndl][nwl][nul]));
	free((FREE_ARG) (&t[nrl][ncl][ndl][nwl]));
	free((FREE_ARG) (&t[nrl][ncl][ndl]));
	free((FREE_ARG) (&t[nrl][ncl]));
	free((FREE_ARG) (&t[nrl]));
       }
}
/*..............................................................................*/
/* allocates the memory for a double 4d-tensor					*/
/* Form Daniel Hoffmann (in NR Convention)					*/

double ****d4tensor(long nrl, long nrh, long ncl, long nch, 
		    long ndl, long ndh, long nwl, long nwh)
{
  long i,j,k,nrow=nrh-nrl+1,ncol=nch-ncl+1,ndep=ndh-ndl+1,nwid=nwh-nwl+1;
  double ****t4, ***t3, **t2, *t1;

  k=nrow*ncol*ndep*nwid;

  t1=(double *)malloc((size_t)(k*sizeof(double)));
  if (!t1)
    muerror("allocation failure 1 in d4tensor");
  t1-=nwl;

  k/=nwid;
  t2=(double **)malloc((size_t)(k*sizeof(double*)));
  if (!t2)
    muerror("allocation failure 2 in d4tensor");
  t2-=ndl;
  for (i=0, j=0; i<k; i++, j+=nwid)
    t2[ndl+i]=&(t1[j]);
    
  k/=ndep;
  t3=(double ***)malloc((size_t)(k*sizeof(double**)));
  if (!t3)
    muerror("allocation failure 3 in d4tensor");
  t3-=ncl;
  for (i=0, j=0; i<k; i++, j+=ndep)
    t3[ncl+i]=&(t2[j]);
    
  k/=ncol;
  t4=(double ****)malloc((size_t)(k*sizeof(double***)));
  if (!t4)
    muerror("allocation failure 4 in d4tensor");
  t4-=nrl;
  for (i=0, j=0; i<k; i++, j+=ncol)
    t4[nrl+i]=&(t3[j]);
    
  return t4;
}
/*..............................................................................*/
/* free a double d4tensor allocated by i4tensor() 				*/
void free_d4tensor(double ****t, long nrl, long nrh, long ncl, long nch, 
		                 long ndl, long ndh, long nwl, long nwh)
{
if (t!=NULL)
	{free((FREE_ARG) (&t[nrl][ncl][ndl][nwl]));
	 free((FREE_ARG) (&t[nrl][ncl][ndl]));
	 free((FREE_ARG) (&t[nrl][ncl]));
	 free((FREE_ARG) (&t[nrl]));
	}
}
/*..............................................................................*/
/* allocates the memory for a float 4d-tensor					*/
/* Form Daniel Hoffmann (in NR Convention)					*/

float ****f4tensor(long nrl, long nrh, long ncl, long nch, 
		   long ndl, long ndh, long nwl, long nwh)
{
  long i,j,k,nrow=nrh-nrl+1,ncol=nch-ncl+1,ndep=ndh-ndl+1,nwid=nwh-nwl+1;
  float ****t4, ***t3, **t2, *t1;

  k=nrow*ncol*ndep*nwid;

  t1=(float *)malloc((size_t)(k*sizeof(float)));
  if (!t1)
    muerror("allocation failure 1 in f4tensor");
  t1-=nwl;

  k/=nwid;
  t2=(float **)malloc((size_t)(k*sizeof(float*)));
  if (!t2)
    muerror("allocation failure 2 in f4tensor");
  t2-=ndl;
  for (i=0, j=0; i<k; i++, j+=nwid)
    t2[ndl+i]=&(t1[j]);
    
  k/=ndep;
  t3=(float ***)malloc((size_t)(k*sizeof(float**)));
  if (!t3)
    muerror("allocation failure 3 in f4tensor");
  t3-=ncl;
  for (i=0, j=0; i<k; i++, j+=ndep)
    t3[ncl+i]=&(t2[j]);
    
  k/=ncol;
  t4=(float ****)malloc((size_t)(k*sizeof(float***)));
  if (!t4)
    muerror("allocation failure 4 in f4tensor");
  t4-=nrl;
  for (i=0, j=0; i<k; i++, j+=ncol)
    t4[nrl+i]=&(t3[j]);
    
  return t4;
}

/*..............................................................................*/
/* free a float i4tensor allocated by i4tensor() 				*/
void free_f4tensor(float ****t, long nrl, long nrh, long ncl, long nch, 
		              long ndl, long ndh, long nwl, long nwh)
{
if (t!=NULL)
	{free((FREE_ARG) (&t[nrl][ncl][ndl][nwl]));
	 free((FREE_ARG) (&t[nrl][ncl][ndl]));
	 free((FREE_ARG) (&t[nrl][ncl]));
	 free((FREE_ARG) (&t[nrl]));
        }

}
/*..............................................................................*/
/* Rountine allocates a vector of (**double)					*/
double ***dpointer_vector(long nrl, long nrh)
{
double ***t;
long nrow=nrh-nrl+1;
/* allocate pointers to pointers to rows */

t=(double ***) malloc((size_t)((nrow+NR_END)*sizeof(double**)));
if (!t) muerror("allocation failure 1 in dpointer_vector()");
t += NR_END;
t -= nrl;

return t;
}


/****************************************************************/
/* 		Other Stuff					*/
/*..............................................................*/
/* procedure translates the three-letter-code into the one-	*/
/* letter-code.							*/
/* If the aminoacid is unknown, 'X' is returned.		*/
/*								*/
char trans_3to1(char *residue)
{
char aa='X';

if (!strncmp(residue,"GLY",3)) {aa =  'G';}
if (!strncmp(residue,"ALA",3)) {aa =  'A';}
if (!strncmp(residue,"ILE",3)) {aa =  'I';}
if (!strncmp(residue,"LEU",3)) {aa =  'L';}
if (!strncmp(residue,"VAL",3)) {aa =  'V';}
if (!strncmp(residue,"GLU",3)) {aa =  'E';}
if (!strncmp(residue,"GLN",3)) {aa =  'Q';}
if (!strncmp(residue,"ASP",3)) {aa =  'D';}
if (!strncmp(residue,"ASN",3)) {aa =  'N';}
if (!strncmp(residue,"ARG",3)) {aa =  'R';}
if (!strncmp(residue,"LYS",3)) {aa =  'K';}
if (!strncmp(residue,"HIS",3)) {aa =  'H';}
if (!strncmp(residue,"SER",3)) {aa =  'S';}
if (!strncmp(residue,"THR",3)) {aa =  'T';}
if (!strncmp(residue,"CYS",3)) {aa =  'C';}
if (!strncmp(residue,"MET",3)) {aa =  'M';}
if (!strncmp(residue,"PRO",3)) {aa =  'P';}
if (!strncmp(residue,"TRP",3)) {aa =  'W';}
if (!strncmp(residue,"TYR",3)) {aa =  'Y';}
if (!strncmp(residue,"PHE",3)) {aa =  'F';}
	
return aa;
}

