/* Das folgende Header-File enthaelt einige Naturkonstanten. 	*/
/* Es werden alle Konstanten in SI-Einheiten angegeben.		*/
#ifndef  __constants__
#define  __constants__

#define  KCAL 
/* For strings and stuff */
#ifndef LINELENGTH
#define LINELENGTH 4000
#endif

#ifndef BOOLEAN
#define TRUE  1
#define FALSE 0
#define BOOLEAN
#endif

/* Convention Factors */
#define A2M	 1e-10			/* Angstrom to Meters */
#define J2CAL	 2.388459e-01
#define CAL2J	 4.186800e+00
#define KCAL2J	 4.186800e+03
#define J2KCAL   2.388459e-04

/* Fundamental Physical Constants */

/* ----------------------------*/
/*#define KILOJOULE*/
#ifdef  KILOJOULE
/* CONV converts a Coulomb term ((q_i[e]*q_j[e]/r[A])) to kJ/mol */
/* CHANGE Achtung in alten programteilen wird conv z.T. falsch verwendet */
#define CONV     	       1.389354846207e+03 /* converts a Coulomb term ((q_i[e]*q_j[e]/r[A])) to kJ/mol */ 
     /* (ELEMENTARY_CHARGE*ELEMENTARY_CHARGE*N_A)/(1000*M_PIt4*EPSILON_0*A2M))*/
#define h_PLANCK   	       6.6260755E-37 		/* Planck constant  in [kJ s]		*/
#define h_DIV_2PI   	       1.05457266E-37 	 	/* Planck constant  h/2 Pi in [kJ s]	*/
#define k_B		       1.380658E-26 	 	/* Boltzmann constant  k_B [kJ/K]	*/
#define R_GAS		       8.3143E-03 		/* Gas constant [kJ/(K*mol)]		*/
#define USED_UNIT	       "kJ/mol"
#endif   /*KILOJOULE*/

/* ----------------------------*/
/*#define JOULE*/
#ifdef  JOULE
/* CONV converts a Coulomb term ((1/4*Pi*eps)*(q_i[e]*q_j[e]/r[A])) to J/mol */
#define CONV     	       1.389354846207e+06	/*(ELEMENTARY_CHARGE*ELEMENTARY_CHARGE*N_A/A2M)*/ 
     /* (ELEMENTARY_CHARGE*ELEMENTARY_CHARGE*N_A)/(M_PIt4*EPSILON_0*A2M))*/
#define h_PLANCK   	       6.6260755E-34 		/* Planck constant  in [J s]		*/
#define h_DIV_2PI   	       1.05457266E-34 	 	/* Planck constant  h/2 Pi in [J s]	*/
#define k_B		       1.380658E-23 	 	/* Boltzmann constant  k_B [J/K]	*/
#define R_GAS		       8.3143 			/* Gas constant [J/(K*mol)]		*/
#define USED_UNIT	       "J/mol"
#endif   /*JOULE*/

/* ----------------------------*/
/* #define KCAL */
#ifdef  KCAL 
/* converts a Coulomb term (1/4*Pi*eps)*(q_i*q_j/r[A]) to kcal/mol */
#define CONV     	       332.0716	  
#define h_PLANCK   	       1.5826109662654e-37	/* Planck constant  in [kcal s]		*/
#define h_DIV_2PI   	       2.5188035609309e-38	/* Planck constant  h/2 Pi in [kcal s]	*/
#define k_B		       3.2976450260220e-27 	/* Boltzmann constant  k_B [kcal/K]	*/
#define R_GAS		       1.9858364663700e-03	/* Gas constant [kcal/(K*mol)]		*/
#define USED_UNIT	       "kcal/mol"
#endif   /*KCAL*/
/* ----------------------------*/


#define EPSILON_0	       8.854187817e-12   	/* Permittivity of vacuum [(As)/(Vm)]   */
#define ELEMENTARY_CHARGE      1.60217733E-19 		/* Elementary charge e [C] 		*/
#define V_MOL		      22.41383 			/* Molar volume [m3/kmol]   		*/
#define N_A		       6.0221367E23  		/* Avogadro number  N_A [particles/mol] */
#define SPEED_OF_LIGHT         2.99792458e8  		/* Speed of light [m/s]			*/

#define PERMEABILITY   	      12.566370614e-7 		/* Permeability of vacuum [T^2*m^3/J]   */
#define FINE_STRUCTURE_CONST 137.0359895 		/* Fine structure constant 		*/
#define ELECTRON_REST_MASS     9.1093897e-31 		/* Electron rest mass [kg] 		*/
#define PROTON_REST_MASS       1.6726231e-27  		/* Proton rest mass [kg] 		*/
#define NEUTRON_REST_MASS      1.6749286e-27 		/* Neutron rest mass [kg] 		*/
#define BOHR_MAGNETON 	       9.2740154e-24 		/* Bohr magneton [J/T] 			*/
#define NUCLEAR_MAGNETON       5.0507866e-27 		/* nuclear magneton [J/T] 		*/
#define FREE_ELECTRON_G_FACTOR 2.002319304386 		/* Free electron g factor 		*/
#define AMU		       1.66057e-27 		/* Atomic mass unit [kg] 		*/ 
#define FARADAY		       9.64846e4 		/* Faraday constant [C/mol] 		*/ 




/* other constants  - t= times*/
#define RAD2DEG  57.29577951308232340205 	/* 180.0/M_PI */
#define DEG2RAD  0.0174532925199433		/* M_PI/180.0 */
#define M_PIt2	 6.28318530717958647692		/* PI*2 */
#define M_PIt4	12.56637061435917295384		/* PI*4 */


/* Some useful constants  form  <math.h> */
#define M_E             2.7182818284590452354
#define M_LOG2E         1.4426950408889634074
#define M_LOG10E        0.43429448190325182765
#define M_LN2           0.69314718055994530942
#define M_LN10          2.30258509299404568402
#define M_PI            3.14159265358979323846
#define M_PI_2          1.57079632679489661923
#define M_PI_4          0.78539816339744830962
#define M_1_PI          0.31830988618379067154
#define M_2_PI          0.63661977236758134308
#define M_2_SQRTPI      1.12837916709551257390
#define M_SQRT2         1.41421356237309504880
#define M_SQRT1_2       0.70710678118654752440


/***** END HERE ***********************************************/

/*
Proton g factor (Lande factor) / g-Faktor des Protons g_H 
#define    5.585 
Gravitational constant / Gravitationskonstante G 
#define    6.6732e-11 m3/kg s2 
Acceleration due to gravity / Erdbeschleunigung g 
#define    9.80665 m/s2 
Compton wavelength of the electron / Compton-Wellenlnge des Elektrons 
lambda_c 
#define    lambda_c = h / (m_e c) 
#define    2.42631e-12 m 

Charge-to-mass ratio for electron / Ladungs-Masse-Verhltnis des Elektrons 
e / m_e 
#define    1.75880e11 C/kg 
Bohr radius / Bohrscher Radius a_0 
#define    5.29177e-11 m 
Electron radius / Elektronenradius r_e 
#define    2.81792e-15 m 

Further Useful Constants / Weitere ntzliche Konstanten

Atomic energy unit / atomare Energieeinheit Hartree 
#define    1 Hartree = e^2 /(4 pi epsilon_0 a_0) 
#define    1 Hartree = 2.625501e+06 J/mol (approx. 627.5 kcal/mol) 

Useful Conversion Factors / Ntzliche Umrechnungsfaktoren

NMR (Nuclear Magnetic Resonance)

Proton Larmor frequency 
#define    nu_p = gamma_p/(2 pi) B 
#define    nu_p = 42.5764 MHz/T (H2O) 

EPR (Electron Paramagnetic Resonance, ESR)

Electron Larmor frequency 
#define    nu_e = gamma_e/(2 pi) g/g_e B 
#define    nu_e [GHz] = 13.9962 g B[T] 
#define    g = 0.07144775 nu_e[GHz]/B[T] 
#define    g = 3.04199 nu_e[GHz]/nu_p[MHz] 
#define    B [T] = 0.0234872 nu_p[MHz] 

Free electron gyromagnetic ratio / gyromagnetisches Verhltnis des freien
Elektrons gamma_e 
#define    gamma_e = 2 pi g_e mu_B / h 
   1.7608592e11 1/s T 
   gamma_e/(2 pi) = 28.024944 GHz/T 
Electron magnetic moment / magnetisches Moment des Elektrons mu_e 
#define    mu_e = -(1/2) g_e mu_B 
   -9.2847701e-24 J/T 
Proton gyromagnetic ratio (H2O) / gyromagnetisches Verhltnis der Protonen
in Wasser gamma_p 
#define    2.67515255e8 1/s T 
#define    gamma_p/(2 pi) = 42.576375 MHz/T 
Proton magnetic moment / magnetisches Moment des Protons mu_p 
#define    1.41060761e-26 J/T 
Proton-electron ratios / Proton-Elektron-Verhltnisse 
#define    m_p/m_e = 1836.152701 
#define    mu_e/mu_p = 658.2106881 
#define    gamma_e/gamma_p = 658.2275841 (protons in water) 

*/
#endif /* __constants__ */


