/*---------------------------------------------------------
    This file is part of the program suite TEN
    (Tools for Elastic Networks)

    Copyright (C)

	Lars Ackermann
    G. Matthias Ullmann
    Bayreuth 2014

    www.bisb.uni-bayreuth.de

    This program is free software: you can redistribute
    it and/or modify it under the terms of the
    GNU Affero General Public License as published by the
    Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will
    be useful, but WITHOUT ANY WARRANTY; without even the
    implied warranty of MERCHANTABILITY or FITNESS FOR A
    PARTICULAR PURPOSE. See the GNU General Public License
    for more details.

    You should have received a copy of the
    GNU Affero General Public License along with this
    program.  If not, see <http://www.gnu.org/licenses/>.
-----------------------------------------------------------*/


#include "SetupConstants.h"
#include <string.h>
#include <iostream>

using namespace std;

SetupConstants::SetupConstants() {
	//if there is a new property in the prop file just add it to this list to make the system recognize the new value
	//then you can use it where ever you want
	settings.insert(std::make_pair("kcovA", 100));
	settings.insert(std::make_pair("kncovA", 1));
	settings.insert(std::make_pair("kcovG", 100));
	settings.insert(std::make_pair("kncovG", 1));
	settings.insert(std::make_pair("rcutG", 6));
	settings.insert(std::make_pair("rcutA", 12));
	settings.insert(std::make_pair("interacMode", 0));
	settings.insert(std::make_pair("massWeightedHessian", 1));
}

SetupConstants::~SetupConstants() {
}

SettingsMap SetupConstants::getSettings() {
	return settings;
}

vector<string> SetupConstants::getNames(){
	return protNames;
}

vector<string> SetupConstants::getPaths(){
	return pqrmPaths;
}

vector<string> SetupConstants::getModels(){
	return models;
}

void SetupConstants::setNames(vector<string> given){
	protNames = given;
}

void SetupConstants::setPaths(vector<string> given){
	pqrmPaths = given;
}

void SetupConstants::setModels(vector<string> given){
	models = given;
}

void SetupConstants::updateSettingsMap(SettingsMap upToDateMap) {
	settings = upToDateMap;
}

bool SetupConstants::isKeyValid(string key) {

	boost::unordered_map<std::string, double>::iterator it;
	it = settings.find(key);
	if(it == settings.end()){
		return false;
	}else{
		return true;
	}
}
